package com.ejianc.business.outputvalcount.api;

import com.ejianc.business.outputvalcount.hyxtrix.OutputValueHystrix;
import com.ejianc.business.outputvalcount.hyxtrix.PayOffHystrix;
import com.ejianc.business.outputvalcount.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

/**
 * 产值统计应收中间库核销表
 * @Author
 */
@FeignClient(name= "zzyj-outputvalcount-web", url="${common.env.feign-client-url}", path="zzyj-outputvalcount-web", fallback = PayOffHystrix.class)

public interface IPayOffApi {

    /**
     * 根据应收中间库和收款记录表生成的核销记录处理
     * @param projectId 项目id
     */
    @RequestMapping(value = "/api/payOff/payOffByProjectId", method= RequestMethod.GET)
    CommonResponse payOffByProjectId(@RequestParam(value = "projectId") Long projectId);
}
