package com.ejianc.business.projectmanage.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目巡检策划
 * 
 * @author generator
 * 
 */
public class PatrolPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long parentOrgId; // 所属单位id
    private String parentOrgName; // 所属单位名称
    private Long projectId; // 工程名称id
    private String projectName; // 工程名称
    private Long userId; // 策划人ID
    private String userName; // 策划人姓名
    private String userPhone; // 策划人联系电话
    private Long patrolGroupId; // 所属巡检组id
    private String patrolGroup; // 所属巡检组
    private Long actualPatrolGroupId; // 执行巡检组id
    private String actualPatrolGroup; // 执行巡检组
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date patrolDate; // 巡检日期
    private Integer isActualPatrolPlan; // 是否执行巡检计划(1:是，0：否)
    private String notActualPatrolPlanReason; // 未执行巡检原因
    private String patrolPlanContent; // 策划内容
    private String patrolSummary; // 巡检总结
    private String gzFileUrl;//
    private String gzFileName;//


    public String getGzFileUrl() {
        return gzFileUrl;
    }

    public void setGzFileUrl(String gzFileUrl) {
        this.gzFileUrl = gzFileUrl;
    }

    public String getGzFileName() {
        return gzFileName;
    }

    public void setGzFileName(String gzFileName) {
        this.gzFileName = gzFileName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getUserId() {
        return userId;
    }
    @ReferDeserialTransfer
    public void setUserId(Long userId) {
        this.userId = userId;
    }
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getPatrolGroupId() {
        return patrolGroupId;
    }
    @ReferDeserialTransfer
    public void setPatrolGroupId(Long patrolGroupId) {
        this.patrolGroupId = patrolGroupId;
    }
    public String getPatrolGroup() {
        return patrolGroup;
    }

    public void setPatrolGroup(String patrolGroup) {
        this.patrolGroup = patrolGroup;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getActualPatrolGroupId() {
        return actualPatrolGroupId;
    }
    @ReferDeserialTransfer
    public void setActualPatrolGroupId(Long actualPatrolGroupId) {
        this.actualPatrolGroupId = actualPatrolGroupId;
    }
    public String getActualPatrolGroup() {
        return actualPatrolGroup;
    }

    public void setActualPatrolGroup(String actualPatrolGroup) {
        this.actualPatrolGroup = actualPatrolGroup;
    }
    public Date getPatrolDate() {
        return patrolDate;
    }

    public void setPatrolDate(Date patrolDate) {
        this.patrolDate = patrolDate;
    }
    public Integer getIsActualPatrolPlan() {
        return isActualPatrolPlan;
    }

    public void setIsActualPatrolPlan(Integer isActualPatrolPlan) {
        this.isActualPatrolPlan = isActualPatrolPlan;
    }
    public String getNotActualPatrolPlanReason() {
        return notActualPatrolPlanReason;
    }

    public void setNotActualPatrolPlanReason(String notActualPatrolPlanReason) {
        this.notActualPatrolPlanReason = notActualPatrolPlanReason;
    }
    public String getPatrolPlanContent() {
        return patrolPlanContent;
    }

    public void setPatrolPlanContent(String patrolPlanContent) {
        this.patrolPlanContent = patrolPlanContent;
    }
    public String getPatrolSummary() {
        return patrolSummary;
    }

    public void setPatrolSummary(String patrolSummary) {
        this.patrolSummary = patrolSummary;
    }
    
}
