package com.ejianc.business.outputvalcount.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.vo.OutputApiVO;
import com.ejianc.business.outputvalcount.vo.OutputvalTargetVO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;

/**
 * 月度产值统计
 * 
 * @author generator
 * 
 */
@Mapper
public interface MonthlyStatisticsMapper extends BaseCrudMapper<MonthlyStatisticsEntity> {
    BigDecimal getSumMny(Long id);
    List<MonthlyStatisticsEntity> getMonthlyStatistics(Long id);
    List<MonthlyStatisticsEntity> getMonthlyStatisticsByDeptId(Long id);
    List<Long> getMonthlyStatisticsByDate(Integer year ,Integer month);
    List<Long> getMonthlyPlanByDate(Integer year ,Integer month);
    List<Long> getImageByDate(String kssj ,String jssj);

    List<MonthlyStatisticsEntity> getSumByOrgIdUnder(@Param(Constants.WRAPPER) QueryWrapper wrapper);


    //BI门户：年度产值目标达成率
    @Select("select output_value_target target_mny from `ejc-companypfm`.t_companypfm_ndqk n\n" +
            "where n.dr = 0\n" +
            "and n.year = #{year}")
    OutputvalTargetVO queryOutputvalYearTarget(String year);


    //BI门户：月度产值分布
    List<String> queryOutputvalCostMonth(String year,@Param(value = "orgIds") List<Long> orgIds);

    List<XmyxglVO> queryMajorProjectIds(@Param(value = "orgIds") List<Long> orgIds);


    List<OutputApiVO> queryUndertakeInfoList(@Param(Constants.WRAPPER) QueryWrapper wrapper);
}
