/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.service.impl;

import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthlyStatisticsService")
public class MonthlyStatisticsServiceImpl
extends BaseServiceImpl<MonthlyStatisticsMapper, MonthlyStatisticsEntity>
implements IMonthlyStatisticsService {
    @Autowired
    private MonthlyStatisticsMapper mapper;

    @Override
    public BigDecimal getSumMny(Long id) {
        return this.mapper.getSumMny(id);
    }

    @Override
    public MonthlyStatisticsEntity getMonthlyStatistics(MonthlyStatisticsEntity monthlyStatisticsEntity) {
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getMonthlyStatistics(monthlyStatisticsEntity.getProjectId());
        int year = monthlyStatisticsEntity.getYear();
        int month = monthlyStatisticsEntity.getMonth();
        BigDecimal kgwccz = new BigDecimal(0);
        BigDecimal bnwccz = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getYear() < year || entity.getYear() == year && entity.getMonth() < month) {
                if (entity.getBillState() != 1 && entity.getBillState() != 3) {
                    throw new BusinessException(entity.getYear() + "\u5e74" + entity.getMonth() + "\u6708\u4efd\u7684\u5355\u636e\u672a\u63d0\u4ea4\u6216\u672a\u5ba1\u6279\u901a\u8fc7\uff01");
                }
                kgwccz = kgwccz.add(entity.getBywccz());
                if (entity.getYear() == year && entity.getMonth() < month) {
                    bnwccz = bnwccz.add(entity.getBywccz());
                }
            }
            if (entity.getYear() != year || entity.getMonth() != month || monthlyStatisticsEntity.getBillCode().equals(entity.getBillCode())) continue;
            throw new BusinessException(entity.getYear() + "\u5e74" + entity.getMonth() + "\u6708\u4efd\u7684\u5355\u636e\u5df2\u5b58\u5728\uff01");
        }
        kgwccz = kgwccz.add(monthlyStatisticsEntity.getBywccz());
        bnwccz = bnwccz.add(monthlyStatisticsEntity.getBywccz());
        monthlyStatisticsEntity.setKgwccz(kgwccz);
        monthlyStatisticsEntity.setBnwccz(bnwccz);
        return monthlyStatisticsEntity;
    }

    @Override
    public List<Long> getMonthlyStatisticsByDate(Integer year, Integer month) {
        return this.mapper.getMonthlyStatisticsByDate(year, month);
    }

    @Override
    public List<Long> getMonthlyPlanByDate(Integer year, Integer month) {
        return this.mapper.getMonthlyPlanByDate(year, month);
    }

    @Override
    public List<Long> getImageByDate(String kssj, String jssj) {
        return this.mapper.getImageByDate(kssj, jssj);
    }
}

