package com.ejianc.business.projectmanage.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.projectmanage.bean.SafeCheckEntity;
import com.ejianc.business.projectmanage.service.ISafeCheckService;
import com.ejianc.business.projectmanage.vo.SafeCheckVO;

/**
 * 安全检查
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("safeCheck")
public class SafeCheckController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISafeCheckService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IWarnCenterApi warnCenterApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SafeCheckVO> saveOrUpdate(@RequestBody SafeCheckVO saveOrUpdateVO) {
    	SafeCheckEntity entity = BeanMapper.map(saveOrUpdateVO, SafeCheckEntity.class);
        UserContext userContextCache =sessionManager.getUserContext();
        if(entity.getId() == null || entity.getId() == 0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	SafeCheckVO vo = BeanMapper.map(entity, SafeCheckVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SafeCheckVO> queryDetail(Long id) {
    	SafeCheckEntity entity = service.selectById(id);
    	SafeCheckVO vo = BeanMapper.map(entity, SafeCheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SafeCheckVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SafeCheckVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SafeCheckVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SafeCheckVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(param.getParams().containsKey("orgId")){//移动端查询

            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().remove("orgId");
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());

        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SafeCheckEntity> page = service.queryPage(param,false);
        IPage<SafeCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SafeCheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SafeCheckEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SafeCheck-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSafeCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SafeCheckVO>> refSafeCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SafeCheckEntity> page = service.queryPage(param,false);
        IPage<SafeCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SafeCheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    @PostMapping(value = "safeWarnExecute")
    public CommonResponse<String> safeWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {//循环每个租户数据
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            /**
             *  1、根据项目维度,查询施工日志台账中的数据
             *  2、根据施工日志台账单据所属组织，找到对应的预警设置，也就是这条施工日志适用于那个设置
             *  3、根据预警设置判断该施工日志数据属于哪个等级
             *  4、符合等级，则拼接预警数据，并保存到list
             *  5、发送数据
             */
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            param.getParams().put("businessStatus", new Parameter(QueryParam.EQ, 2));
            param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

            //查询项目状态为在建的项目
            CommonResponse<JSONArray> queryProjectPoolList = projectPoolApi.getProjectPoolList(param);

            List<ProjectPoolSetVO> projectPoolSetVOS = new ArrayList<>();
            if(queryProjectPoolList.isSuccess()){
                JSONArray poolListData = queryProjectPoolList.getData();
                logger.info("查询出来的项目---------------------{}",poolListData);
                projectPoolSetVOS = JSON.parseArray(JSON.toJSONString(poolListData), ProjectPoolSetVO.class);
                logger.info("解析查询出来的项目---------------------{}",projectPoolSetVOS);

                projectPoolSetVOS = projectPoolSetVOS.stream().filter(
                        s-> (s.getSimpleFlag() != null && !"1".equals(s.getSimpleFlag()))
                                || StringUtils.isEmpty(s.getSimpleFlag())
                          //非简管项目

                ).collect(Collectors.toList());
                logger.info("预警项目------------------------{}",projectPoolSetVOS);
            }

            if (ListUtil.isNotEmpty(projectPoolSetVOS)) {
                for (ProjectPoolSetVO projectPoolSetVO: projectPoolSetVOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
//
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的innerCode进行父级查找
                     * */
//
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        /** 间隔天数 */
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");

                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        /*BigDecimal overAmtHigh = null;
                        BigDecimal overAmtMeddle = null;
                        BigDecimal overAmtLow = null;*/

                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            LocalDate date = LocalDate.now();
                            if ("高".equals(set.getString("warningLevel"))) {
                                int day = Integer.parseInt(set.getString("parameterValue"));
                                String startDate = date.minusDays(day).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                String endDate = date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                List<SafeCheckEntity> list = service.list(Wrappers.<SafeCheckEntity>lambdaQuery()
                                        .eq(SafeCheckEntity::getProjectId, projectPoolSetVO.getId())
                                        .between(SafeCheckEntity::getStartDate, startDate, endDate)
                                );
                                logger.info("预警等级高时间条件为{}{}",startDate,endDate);
                                logger.info("查询数据为{}",list);
                                if (ListUtil.isEmpty(list)) {
                                    //overAmtHigh = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    high = true;
                                    useSetHigh = set;
                                }
                            }

//
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName")+"-"+projectPoolSetVO.getName());
                            vo.setPcTitle("项目周检预警");
                            vo.setOrgId(projectPoolSetVO.getOrgId());
                            vo.setSendOrgId(String.valueOf(projectPoolSetVO.getOrgId()));
                            vo.setOrgName(projectPoolSetVO.getOrgName());
                            vo.setSourceId(projectPoolSetVO.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", projectPoolSetVO.getName())
                                                .replaceAll("#day#","5")
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", projectPoolSetVO.getName())
                                                .replaceAll("#day#","1")
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", projectPoolSetVO.getName())
                                                .replaceAll("#day#",null)
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }

        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        logger.info("预警中心响应：{}", JSON.toJSONString(warnResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        return CommonResponse.success("任务接受处理成功！");
    }
}
