/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsPayDetailEntity;
import com.ejianc.business.outputvalcount.bean.PayDetailSourceEntity;
import com.ejianc.business.outputvalcount.controller.api.PayOffApi;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.business.outputvalcount.service.IPayDetailSourceService;
import com.ejianc.business.outputvalcount.service.IPayOffService;
import com.ejianc.business.receipt.api.IReceiptRegisterApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthlyStatistics")
public class MonthlyStatisticsBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IMonthlyStatisticsService service;
    @Autowired
    private MonthlyStatisticsMapper mapper;
    @Autowired
    private IPayDetailSourceService payDetailSourceService;
    @Autowired
    private IReceiptRegisterApi receiptRegisterApi;
    @Autowired
    private IPayOffService payOffService;
    @Autowired
    private PayOffApi payOffApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        MonthlyStatisticsEntity monthlyStatisticsEntity = (MonthlyStatisticsEntity)((Object)this.service.getById(billId));
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getMonthlyStatistics(monthlyStatisticsEntity.getProjectId());
        int year = monthlyStatisticsEntity.getYear();
        int month = monthlyStatisticsEntity.getMonth();
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getYear() <= year && (entity.getYear() != year || entity.getMonth() <= month) || entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            throw new BusinessException(entity.getYear() + "\u5e74" + entity.getMonth() + "\u6708\u4efd\u7684\u5355\u636e\u5df2\u63d0\u4ea4\u6216\u5ba1\u6279\u901a\u8fc7\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MonthlyStatisticsEntity statisticsEntity = (MonthlyStatisticsEntity)((Object)this.service.selectById(billId));
        List<MonthlyStatisticsPayDetailEntity> payDetailList = statisticsEntity.getMonthlyStatisticsPayDetailList();
        if (ListUtil.isNotEmpty(payDetailList)) {
            this.logger.info("1---------\u63a8\u9001\u5e94\u6536\u4e2d\u95f4\u5e93\u5f00\u59cb{}", (Object)JSON.toJSONString(payDetailList));
            for (MonthlyStatisticsPayDetailEntity payDetailEntity : payDetailList) {
                if (!"\u5e94\u6536".equals(payDetailEntity.getDetailType())) continue;
                PayDetailSourceEntity payDetailSourceEntity = new PayDetailSourceEntity();
                if (payDetailEntity.getLastId() == null) {
                    payDetailSourceEntity.setSourceId(payDetailEntity.getId());
                    payDetailSourceEntity.setPayPer(payDetailEntity.getPayPer());
                    payDetailSourceEntity.setPayRemarkId(payDetailEntity.getPayRemarkId());
                    payDetailSourceEntity.setPayNode(payDetailEntity.getPayNode());
                    payDetailSourceEntity.setPayNodeNum(payDetailEntity.getPayNodeNum());
                    payDetailSourceEntity.setServiceDate(new Date());
                    payDetailSourceEntity.setProjectId(payDetailEntity.getProjectId());
                    payDetailSourceEntity.setProjectName(payDetailEntity.getProjectName());
                    payDetailSourceEntity.setQuoteMny(payDetailEntity.getQuoteMny());
                    payDetailSourceEntity.setReceiveMny(payDetailEntity.getReceiveMny());
                    payDetailSourceEntity.setActualMny(BigDecimal.ZERO);
                    payDetailSourceEntity.setUnMny(payDetailEntity.getReceiveMny());
                    this.logger.info("2---------\u63a8\u9001\u5e94\u6536\u4e2d\u95f4\u5e93\u6570\u636e{}", (Object)JSON.toJSONString((Object)((Object)payDetailSourceEntity)));
                } else {
                    payDetailSourceEntity = (PayDetailSourceEntity)((Object)this.payDetailSourceService.getOne((Wrapper)Wrappers.lambdaQuery().eq(PayDetailSourceEntity::getSourceId, (Object)payDetailEntity.getLastId())));
                    payDetailSourceEntity.setQuoteMny(payDetailEntity.getQuoteMny());
                    payDetailSourceEntity.setReceiveMny(payDetailEntity.getReceiveMny());
                    BigDecimal unMny = payDetailEntity.getReceiveMny().subtract(payDetailSourceEntity.getActualMny());
                    payDetailSourceEntity.setUnMny(unMny);
                    payDetailSourceEntity.setServiceDate(new Date());
                    this.logger.info("2---------\u4fee\u6539\u5e94\u6536\u4e2d\u95f4\u5e93\u6570\u636e{}", (Object)JSON.toJSONString((Object)((Object)payDetailSourceEntity)));
                }
                this.payDetailSourceService.saveOrUpdate((Object)payDetailSourceEntity);
            }
        }
        this.payOffApi.payOffByProjectId(statisticsEntity.getProjectId());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MonthlyStatisticsEntity monthlyStatisticsEntity = (MonthlyStatisticsEntity)((Object)this.service.selectById(billId));
        if (ListUtil.isEmpty(monthlyStatisticsEntity.getMonthlyStatisticsPayDetailList())) {
            return CommonResponse.error((String)"\u5df2\u63a8\u9001\u6536\u6b3e\u6838\u9500\u8868\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseProjectUser".equals(sign)) {
            MonthlyStatisticsEntity entity = (MonthlyStatisticsEntity)((Object)this.service.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long patrolManager = vo.getPatrolManager();
            String patrolManagerName = vo.getPatrolManagerName();
            this.logger.info("userId:{}", (Object)patrolManager);
            this.logger.info("userName:{}", (Object)patrolManagerName);
            jsonObject.put("userId", (Object)patrolManager);
            jsonObject.put("userName", (Object)patrolManagerName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

