/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.context.filter;

import com.yonyou.iuap.context.InvocationInfoProxy;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ContextFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int SC_INTERNAL_SERVER_ERROR = 500;
    private static final String PARAM_SYSID = "u_sysid";
    private static final String PARAM_CALLID = "u_callid";
    private static final String PARAM_LOCALE = "u_locale";
    private static final String PARAM_THEME = "u_theme";
    private static final String PARAM_TIMEZONE = "u_timezone";
    private static final String PARAM_TENANTID = "tenantid";
    private static final String PARAM_USERCODE = "u_usercode";
    private static final String PARAM_TOKEN = "token";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse rp = (HttpServletResponse)response;
        try {
            Cookie[] cookies = hrequest.getCookies();
            String authority = hrequest.getHeader("Authority");
            if (StringUtils.isNotBlank((CharSequence)authority)) {
                String[] ac;
                HashSet<Cookie> cookieSet = new HashSet<Cookie>();
                for (String s : ac = authority.split(";")) {
                    String[] cookieArr = s.split("=");
                    String key = StringUtils.trim((String)cookieArr[0]);
                    String value = StringUtils.trim((String)cookieArr[1]);
                    Cookie cookie = new Cookie(key, value);
                    cookieSet.add(cookie);
                }
                cookies = cookieSet.toArray(new Cookie[0]);
            }
            for (Cookie cookie : cookies) {
                String cname = cookie.getName();
                String cvalue = cookie.getValue();
                if (cname.equals(PARAM_SYSID)) {
                    InvocationInfoProxy.setSysid(cvalue);
                    continue;
                }
                if (cname.equals(PARAM_TENANTID)) {
                    InvocationInfoProxy.setTenantid(cvalue);
                    continue;
                }
                if (cname.equals(PARAM_USERCODE)) {
                    InvocationInfoProxy.setUserid(cvalue);
                    continue;
                }
                if (cname.equals(PARAM_CALLID)) {
                    InvocationInfoProxy.setCallid(cvalue);
                    continue;
                }
                if (cname.equals(PARAM_LOCALE)) {
                    InvocationInfoProxy.setLocale(cvalue);
                    continue;
                }
                if (cname.equals(PARAM_TIMEZONE)) {
                    InvocationInfoProxy.setTimeZone(cvalue);
                    continue;
                }
                if (cname.equals(PARAM_TOKEN)) {
                    InvocationInfoProxy.setToken(cvalue);
                    continue;
                }
                if (cname.equals(PARAM_THEME)) {
                    InvocationInfoProxy.setTheme(PARAM_THEME);
                    continue;
                }
                if (cname.equals("current_tenant_id")) {
                    MDC.put((String)"current_tenant_id", (String)cvalue);
                    continue;
                }
                if (cname.equals("current_user_name")) {
                    MDC.put((String)"current_user_name", (String)cvalue);
                    continue;
                }
                if (cname.equals("call_thread_id")) {
                    MDC.put((String)"call_thread_id", (String)cvalue);
                    continue;
                }
                InvocationInfoProxy.setParameter(cname, cvalue);
            }
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            rp.setStatus(500);
            rp.getWriter().write("get InvocationInfo error:" + e.getMessage());
            throw new RuntimeException("get InvocationInfo error!");
        }
        finally {
            this.clear();
        }
    }

    private void clear() {
        InvocationInfoProxy.reset();
        MDC.remove((String)"current_user_name");
        MDC.remove((String)"call_thread_id");
        MDC.remove((String)"current_tenant_id");
    }

    public void destroy() {
    }
}

