/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.persistence.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yonyou.iuap.persistence.vo.annotation.MetaGetter;
import com.yonyou.iuap.persistence.vo.annotation.MetaSetter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEntity
implements Serializable {
    private static final long serialVersionUID = -7809390157226007316L;
    private static final Logger logger = LoggerFactory.getLogger(BaseEntity.class);
    protected String metaDefinedName;
    protected String namespace;
    private Integer status = 0;
    private String[] changedPropertyNames;
    private transient Map<String, Object> beanMap = new HashMap<String, Object>();
    private transient BeanMap originMap;

    public BaseEntity() {
    }

    public BaseEntity(Map<String, Object> extProperty) {
        if (extProperty != null && !extProperty.isEmpty()) {
            this.beanMap.putAll(extProperty);
        }
    }

    @MetaGetter
    public final <T> T getAttribute(String fieldName) throws RuntimeException {
        if (this.beanMap != null && this.beanMap.containsKey(fieldName)) {
            return (T)this.beanMap.get(fieldName);
        }
        this.originMap = this.createProxy();
        if (this.originMap.containsKey((Object)fieldName)) {
            return (T)this.originMap.get((Object)fieldName);
        }
        logger.error("Property " + fieldName + " not Found!!");
        return null;
    }

    @JsonIgnore
    public List<String> getAllAttributeNames() {
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.addAll(this.createProxy().keySet());
        if (this.beanMap != null) {
            propertyList.addAll(this.beanMap.keySet());
        }
        return propertyList;
    }

    private synchronized BeanMap createProxy() {
        this.originMap = this.originMap == null ? BeanMap.create((Object)this) : this.originMap;
        return this.originMap;
    }

    @MetaSetter
    public final <T> void setAttribute(String fieldName, T value) {
        this.originMap = this.createProxy();
        if (this.originMap.containsKey((Object)fieldName)) {
            this.originMap.put((Object)fieldName, value);
        } else {
            if (this.beanMap == null) {
                this.beanMap = new HashMap<String, Object>();
            }
            this.beanMap.put(fieldName, value);
        }
    }

    public <T> T removeExtProperty(String propertyName) {
        return (T)this.beanMap.remove(propertyName);
    }

    @JsonIgnore
    public Map<String, Object> getBeanMap() {
        if (this.beanMap != null) {
            try {
                return (Map)BeanUtils.cloneBean(this.beanMap);
            }
            catch (IllegalAccessException e) {
                logger.error("Fail to getBeanMap", (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error("Fail to getBeanMap", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error("Fail to getBeanMap", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Fail to getBeanMap", (Throwable)e);
            }
        }
        return null;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status == null ? 0 : status;
    }

    public String[] getChangedPropertyNames() {
        return this.changedPropertyNames;
    }

    public void setChangedPropertyNames(String[] changedPropertyNames) {
        this.changedPropertyNames = changedPropertyNames;
    }

    public String getMetaDefinedName() {
        if (StringUtils.isBlank((CharSequence)this.metaDefinedName)) {
            throw new IllegalArgumentException("Meta Defined name must be set!");
        }
        return this.metaDefinedName;
    }

    public void setMetaDefinedName(String metaDefinedName) {
        this.metaDefinedName = metaDefinedName;
    }

    public String getNamespace() {
        if (StringUtils.isBlank((CharSequence)this.namespace)) {
            throw new IllegalArgumentException("Meta Defined name must be set!");
        }
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

