/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.rabbitmq.client.Channel;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.mq.common.MqMessage;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractFanoutConsumer
implements InitializingBean,
DisposableBean,
ChannelAwareMessageListener {
    protected static Logger logger = LoggerFactory.getLogger(AbstractFanoutConsumer.class);
    @Resource(name="icopRabbitAdmin")
    private RabbitAdmin rabbitAdmin;
    @Resource(name="icopRabbitTemplate")
    private RabbitTemplate rabbitTemplate;
    private SimpleMessageListenerContainer container;

    public void destroy() throws Exception {
        logger.debug("\u5173\u95ed\u76d1\u542c...");
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void afterPropertiesSet() throws Exception {
        Queue queue = this.rabbitAdmin.declareQueue();
        FanoutExchange exchange = new FanoutExchange(this.getExchangeName());
        this.rabbitAdmin.declareExchange((Exchange)exchange);
        Binding binding = BindingBuilder.bind((Queue)queue).to(exchange);
        this.rabbitAdmin.declareBinding(binding);
        this.container = new SimpleMessageListenerContainer();
        this.container.setConnectionFactory(this.rabbitTemplate.getConnectionFactory());
        this.container.setMessageListener((Object)this);
        this.container.setQueueNames(new String[]{queue.getName()});
        System.out.println("fanout \u6d88\u8d39\u8005\u7ed1\u5b9a\u961f\u5217\u540d" + queue.getName());
        this.container.start();
    }

    public void onMessage(Message message, Channel channel) throws Exception {
        String msg = new String(message.getBody(), "UTF-8");
        MqMessage mqMessage = (MqMessage)JSON.parseObject((String)msg, MqMessage.class);
        if (mqMessage == null || mqMessage.getBody() == null) {
            logger.error("\u6d88\u606f\u4f53\u4e3a\u7a7a\uff0c\u820d\u5f03\uff01");
            return;
        }
        if (mqMessage.getTenantid() != null) {
            InvocationInfoProxy.setTenantid((String)mqMessage.getTenantid());
        }
        if (mqMessage.getToken() != null) {
            InvocationInfoProxy.setToken((String)mqMessage.getToken());
        }
        this.doConsumeMsg(mqMessage);
        System.out.println("msg\uff1a" + msg);
    }

    protected abstract void doConsumeMsg(MqMessage var1);

    protected abstract String getExchangeName();

    private class Listener {
        private Listener() {
        }

        public void handleMessage(byte[] bytes) throws UnsupportedEncodingException {
            String msg = new String(bytes, "UTF-8");
            System.out.println("Object \u5185\u90e8\u7684\u65b9\u6cd5\uff1a" + msg);
        }
    }
}

