/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.rabbitmq.client.Channel;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.mq.common.MqMessage;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseConsumer
implements InitializingBean,
ChannelAwareMessageListener,
DisposableBean {
    protected static Logger logger = LoggerFactory.getLogger(BaseConsumer.class);
    @Resource(name="icopRabbitAdmin")
    private RabbitAdmin rabbitAdmin;
    @Resource(name="icopRabbitTemplate")
    private RabbitTemplate rabbitTemplate;
    private SimpleMessageListenerContainer listenerContainer;
    public static final String DEFAULT_CHARSET = "UTF-8";

    public void afterPropertiesSet() {
        Object[] queueNames = this.getQueueNames();
        if (ArrayUtils.isEmpty((Object[])queueNames)) {
            logger.warn("\u6ca1\u6709\u8bbe\u7f6e\u9700\u8981\u6d88\u8d39\u7684\u961f\u5217");
            return;
        }
        this.listenerContainer = new SimpleMessageListenerContainer();
        this.listenerContainer.setConnectionFactory(this.rabbitTemplate.getConnectionFactory());
        Queue[] queues = new Queue[queueNames.length];
        for (Object queueName : queueNames) {
            Queue queue = new Queue((String)queueName, true, false, false);
            this.rabbitAdmin.declareQueue(queue);
            queues[i] = queue;
        }
        this.listenerContainer.addQueues(queues);
        this.listenerContainer.setPrefetchCount(1);
        this.listenerContainer.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        this.listenerContainer.setMessageListener((Object)this);
        this.listenerContainer.start();
    }

    public void destroy() {
        logger.debug("\u5173\u95ed\u76d1\u542c...");
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
        }
    }

    public void onMessage(Message message, Channel channel) throws Exception {
        String msg = new String(message.getBody(), DEFAULT_CHARSET);
        logger.debug("\u63a5\u6536\u5230\u6d88\u606f\uff1a" + msg);
        MessageProperties msgProps = message.getMessageProperties();
        channel.basicAck(msgProps.getDeliveryTag(), false);
        try {
            MqMessage mqMessage = (MqMessage)JSON.parseObject((String)msg, MqMessage.class);
            if (mqMessage == null || mqMessage.getBody() == null) {
                logger.error("\u6d88\u606f\u4f53\u4e3a\u7a7a\uff0c\u820d\u5f03\uff01");
                return;
            }
            if (mqMessage.getTenantid() != null) {
                InvocationInfoProxy.setTenantid((String)mqMessage.getTenantid());
            }
            if (mqMessage.getToken() != null) {
                InvocationInfoProxy.setToken((String)mqMessage.getToken());
            }
            this.doConsumeMsg(mqMessage);
            logger.debug("\u6d88\u606f\u6d88\u8d39\u5b8c\u6210");
        }
        catch (Exception ex) {
            logger.error("\u6d88\u606f\u6d88\u8d39\u5931\u8d25:", (Throwable)ex);
        }
    }

    protected abstract void doConsumeMsg(MqMessage var1);

    protected abstract String[] getQueueNames();
}

