/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.mq.converter;

import com.alibaba.fastjson.JSON;
import com.yyjz.icop.mq.common.MqConfig;
import java.io.UnsupportedEncodingException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;

public class FastJsonMessageConverter
extends AbstractMessageConverter {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private volatile String defaultCharset = "UTF-8";

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : DEFAULT_CHARSET;
    }

    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties) {
        byte[] bytes = null;
        try {
            String jsonString = JSON.toJSONString((Object)objectToConvert);
            bytes = jsonString.getBytes(this.defaultCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageConversionException("Failed to convert Message content", (Throwable)e);
        }
        messageProperties.setContentType("application/json");
        messageProperties.setContentEncoding(this.defaultCharset);
        if (bytes != null) {
            messageProperties.setContentLength((long)bytes.length);
        }
        return new Message(bytes, messageProperties);
    }

    public Object fromMessage(Message message) throws MessageConversionException {
        String json = "";
        try {
            json = new String(message.getBody(), this.defaultCharset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return JSON.parse((String)json);
    }

    public static void main(String[] args) {
        MqConfig config = new MqConfig();
        config.setHost("localhost");
        String str = "123";
        System.out.println(JSON.toJSONString((Object)config));
    }
}

