/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.mq.sender.impl;

import com.yyjz.icop.mq.common.MqMessage;
import com.yyjz.icop.mq.sender.MsgSender;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class MsgSenderImpl
implements MsgSender {
    private Logger logger = LoggerFactory.getLogger(MsgSenderImpl.class);
    @Resource(name="icopRabbitAdmin")
    private RabbitAdmin rabbitAdmin;
    @Resource(name="icopRabbitTemplate")
    private RabbitTemplate rabbitTemplate;
    private static final String defaultRouteKey = "";
    private static final String utf8Encode = "UTF-8";
    private static Set<String> queueHashSet = new HashSet<String>();

    @Override
    public void sendMessage(MqMessage message, String queueName) {
        if (message == null) {
            this.logger.warn("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u6d88\u606f\u4e3anull");
            return;
        }
        if (!queueHashSet.contains(queueName)) {
            Queue queue = new Queue(queueName, true, false, false);
            this.rabbitAdmin.declareQueue(queue);
            queueHashSet.add(queueName);
        }
        if (message.getId() == null) {
            message.setId(UUID.randomUUID().toString());
        }
        this.rabbitTemplate.convertAndSend(queueName, (Object)message);
    }
}

