/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.merger.pagination;

import io.shardingjdbc.core.merger.ResultSetMerger;
import io.shardingjdbc.core.merger.common.AbstractDecoratorResultSetMerger;
import io.shardingjdbc.core.parsing.parser.context.limit.Limit;
import java.sql.SQLException;

public final class LimitDecoratorResultSetMerger
extends AbstractDecoratorResultSetMerger {
    private final Limit limit;
    private final boolean skipAll;
    private int rowNumber;

    public LimitDecoratorResultSetMerger(ResultSetMerger resultSetMerger, Limit limit) throws SQLException {
        super(resultSetMerger);
        this.limit = limit;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        for (int i = 0; i < this.limit.getOffsetValue(); ++i) {
            if (this.getResultSetMerger().next()) continue;
            return true;
        }
        this.rowNumber = 0;
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (this.limit.getRowCountValue() < 0) {
            return this.getResultSetMerger().next();
        }
        return ++this.rowNumber <= this.limit.getRowCountValue() && this.getResultSetMerger().next();
    }
}

