/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.context;

import com.google.common.base.Optional;
import io.shardingjdbc.core.constant.OrderType;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class OrderItem {
    private final Optional<String> owner;
    private final Optional<String> name;
    private final OrderType type;
    private final OrderType nullOrderType;
    private int index = -1;
    private Optional<String> alias;

    public OrderItem(String name, OrderType type, OrderType nullOrderType, Optional<String> alias) {
        this.owner = Optional.absent();
        this.name = Optional.of((Object)name);
        this.type = type;
        this.nullOrderType = nullOrderType;
        this.alias = alias;
    }

    public OrderItem(String owner, String name, OrderType type, OrderType nullOrderType, Optional<String> alias) {
        this.owner = Optional.of((Object)owner);
        this.name = Optional.of((Object)name);
        this.type = type;
        this.nullOrderType = nullOrderType;
        this.alias = alias;
    }

    public OrderItem(int index, OrderType type, OrderType nullOrderType) {
        this.owner = Optional.absent();
        this.name = Optional.absent();
        this.index = index;
        this.type = type;
        this.nullOrderType = nullOrderType;
        this.alias = Optional.absent();
    }

    public String getColumnLabel() {
        return this.alias.isPresent() ? (String)this.alias.get() : (String)this.name.orNull();
    }

    public Optional<String> getQualifiedName() {
        if (!this.name.isPresent()) {
            return Optional.absent();
        }
        return this.owner.isPresent() ? Optional.of((Object)((String)this.owner.get() + "." + (String)this.name.get())) : this.name;
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof OrderItem)) {
            return false;
        }
        OrderItem orderItem = (OrderItem)obj;
        return this.type == orderItem.getType() && (this.columnLabelEquals(orderItem) || this.qualifiedNameEquals(orderItem) || this.indexEquals(orderItem));
    }

    private boolean columnLabelEquals(OrderItem orderItem) {
        String columnLabel = this.getColumnLabel();
        return null != columnLabel && columnLabel.equalsIgnoreCase(orderItem.getColumnLabel());
    }

    private boolean qualifiedNameEquals(OrderItem orderItem) {
        Optional<String> thisQualifiedName = this.getQualifiedName();
        Optional<String> thatQualifiedName = orderItem.getQualifiedName();
        return thisQualifiedName.isPresent() && thatQualifiedName.isPresent() && ((String)thisQualifiedName.get()).equalsIgnoreCase((String)thatQualifiedName.get());
    }

    private boolean indexEquals(OrderItem orderItem) {
        return -1 != this.index && this.index == orderItem.getIndex();
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public OrderType getType() {
        return this.type;
    }

    public OrderType getNullOrderType() {
        return this.nullOrderType;
    }

    public int getIndex() {
        return this.index;
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setAlias(Optional<String> alias) {
        this.alias = alias;
    }

    public String toString() {
        return "OrderItem(owner=" + this.getOwner() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", nullOrderType=" + (Object)((Object)this.getNullOrderType()) + ", index=" + this.getIndex() + ", alias=" + this.getAlias() + ")";
    }
}

