/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.context.table;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingjdbc.core.parsing.parser.context.table.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class Tables {
    private final List<Table> tables = new ArrayList<Table>();

    public void add(Table table) {
        this.tables.add(table);
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public boolean isSingleTable() {
        return 1 == this.tables.size();
    }

    public String getSingleTableName() {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0);
        return this.tables.get(0).getName();
    }

    public Collection<String> getTableNames() {
        HashSet<String> result = new HashSet<String>(this.tables.size(), 1.0f);
        for (Table each : this.tables) {
            result.add(each.getName());
        }
        return result;
    }

    public Optional<Table> find(String tableNameOrAlias) {
        Optional<Table> tableFromName = this.findTableFromName(tableNameOrAlias);
        return tableFromName.isPresent() ? tableFromName : this.findTableFromAlias(tableNameOrAlias);
    }

    private Optional<Table> findTableFromName(String name) {
        for (Table each : this.tables) {
            if (!each.getName().equals(name)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private Optional<Table> findTableFromAlias(String alias) {
        for (Table each : this.tables) {
            if (!each.getAlias().isPresent() || !((String)each.getAlias().get()).equals(alias)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public String toString() {
        return "Tables(tables=" + this.tables + ")";
    }
}

