/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.admin;

import com.google.caja.util.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.admin.ContainerAdminData;
import org.apache.shindig.gadgets.admin.FeatureAdminData;
import org.apache.shindig.gadgets.admin.GadgetAdminData;
import org.apache.shindig.gadgets.admin.GadgetAdminStore;
import org.apache.shindig.gadgets.admin.RpcAdminData;
import org.apache.shindig.gadgets.admin.ServerAdminData;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class BasicGadgetAdminStore
implements GadgetAdminStore {
    private static final String WHITELIST_KEY = "gadgets.admin.enableGadgetWhitelist";
    private static final String ENABLE_FEATURE_ADMIN = "gadgets.admin.enableFeatureAdministration";
    private static final Logger LOG = Logger.getLogger(BasicGadgetAdminStore.class.getName());
    private static final String GADGETS = "gadgets";
    private static final String FEATURES = "features";
    private static final String FEATURES_NAMES = "names";
    private static final String TYPE = "type";
    private static final String RPC = "rpc";
    private static final String ADDITIONAL_RPC_SERVICE_IDS = "additionalServiceIds";
    private static final String BLACKLIST = "blacklist";
    private static final String CORE_FEATURE = "core";
    private ServerAdminData serverAdminData;
    private FeatureRegistryProvider featureRegistryProvider;
    private ContainerConfig config;

    @Inject
    public BasicGadgetAdminStore(FeatureRegistryProvider featureRegistryProvider, ContainerConfig config, ServerAdminData serverAdminData) {
        this.serverAdminData = serverAdminData;
        this.featureRegistryProvider = featureRegistryProvider;
        this.config = config;
    }

    public void init(String store) throws GadgetException {
        try {
            JSONObject json = new JSONObject(store);
            Iterator iter = json.keys();
            while (iter.hasNext()) {
                String container = (String)iter.next();
                this.serverAdminData.addContainerAdminData(container, this.createContainerData(container, json.getJSONObject(container)));
            }
        }
        catch (JSONException e) {
            throw new GadgetException(GadgetException.Code.GADGET_ADMIN_STORAGE_ERROR, (Throwable)e);
        }
    }

    private ContainerAdminData createContainerData(String container, JSONObject containerJson) throws JSONException, GadgetException {
        ContainerAdminData containerData = new ContainerAdminData();
        if (containerJson.has(GADGETS)) {
            containerData = new ContainerAdminData(this.createGadgetAdminDataMap(containerJson.getJSONObject(GADGETS)));
        }
        return containerData;
    }

    private RpcAdminData createRpcAdminData(JSONObject rpcJson) throws JSONException {
        RpcAdminData adminData = new RpcAdminData();
        if (rpcJson.has(ADDITIONAL_RPC_SERVICE_IDS)) {
            JSONArray ids = rpcJson.getJSONArray(ADDITIONAL_RPC_SERVICE_IDS);
            for (int i = 0; i < ids.length(); ++i) {
                adminData.addAdditionalRpcServiceId(ids.getString(i));
            }
        }
        return adminData;
    }

    private Map<String, GadgetAdminData> createGadgetAdminDataMap(JSONObject gadgetsJson) throws JSONException {
        HashMap map = Maps.newHashMap();
        Iterator keys = gadgetsJson.keys();
        while (keys.hasNext()) {
            String gadgetUrl = (String)keys.next();
            JSONObject gadgetJson = gadgetsJson.getJSONObject(gadgetUrl);
            map.put(gadgetUrl, this.createGadgetAdminData(gadgetJson));
        }
        return map;
    }

    private GadgetAdminData createGadgetAdminData(JSONObject gadgetJson) throws JSONException {
        FeatureAdminData featureData = new FeatureAdminData();
        RpcAdminData rpcData = new RpcAdminData();
        if (gadgetJson.has(FEATURES)) {
            featureData = this.createFeatureAdminData(gadgetJson.getJSONObject(FEATURES));
        }
        if (gadgetJson.has(RPC)) {
            rpcData = this.createRpcAdminData(gadgetJson.getJSONObject(RPC));
        }
        return new GadgetAdminData(featureData, rpcData);
    }

    private FeatureAdminData createFeatureAdminData(JSONObject featuresJson) throws JSONException {
        String type;
        FeatureAdminData data = new FeatureAdminData();
        if (featuresJson.has(FEATURES_NAMES)) {
            JSONArray features = featuresJson.getJSONArray(FEATURES_NAMES);
            for (int i = 0; i < features.length(); ++i) {
                data.addFeature(features.getString(i));
            }
        }
        data.setType(FeatureAdminData.Type.WHITELIST);
        if (!data.getFeatures().contains(CORE_FEATURE)) {
            data.addFeature(CORE_FEATURE);
        }
        if (featuresJson.has(TYPE) && (type = featuresJson.getString(TYPE)).equalsIgnoreCase(BLACKLIST)) {
            data.setType(FeatureAdminData.Type.BLACKLIST);
            data.removeFeature(CORE_FEATURE);
        }
        return data;
    }

    @Override
    public GadgetAdminData getGadgetAdminData(String container, String gadgetUrl) {
        ContainerAdminData containerData;
        GadgetAdminData data = null;
        if (this.serverAdminData.hasContainerAdminData(container) && (containerData = this.serverAdminData.getContainerAdminData(container)).hasGadgetAdminData(gadgetUrl)) {
            data = containerData.getGadgetAdminData(gadgetUrl);
        }
        return data;
    }

    @Override
    public void setGadgetAdminData(String container, String gadgetUrl, GadgetAdminData adminData) {
        if (this.serverAdminData.hasContainerAdminData(container)) {
            ContainerAdminData containerData = this.serverAdminData.getContainerAdminData(container);
            containerData.addGadgetAdminData(gadgetUrl, adminData);
        }
    }

    @Override
    public ContainerAdminData getContainerAdminData(String container) {
        ContainerAdminData data = null;
        if (this.serverAdminData.hasContainerAdminData(container)) {
            data = this.serverAdminData.getContainerAdminData(container);
        }
        return data;
    }

    @Override
    public void setContainerAdminData(String container, ContainerAdminData containerAdminData) {
        this.serverAdminData.addContainerAdminData(container, containerAdminData);
    }

    @Override
    public ServerAdminData getServerAdminData() {
        return this.serverAdminData;
    }

    private String getSafeContainerFromGadget(Gadget gadget) {
        GadgetContext context = gadget.getContext();
        if (context != null) {
            return context.getContainer();
        }
        return null;
    }

    private String getSafeGadgetUrlFromGadget(Gadget gadget) {
        Uri gadgetUri;
        GadgetSpec spec = gadget.getSpec();
        if (spec != null && (gadgetUri = spec.getUrl()) != null) {
            return gadgetUri.toString();
        }
        return null;
    }

    @Override
    public boolean checkFeatureAdminInfo(Gadget gadget) {
        String container = this.getSafeContainerFromGadget(gadget);
        String gadgetUrl = this.getSafeGadgetUrlFromGadget(gadget);
        if (container == null || gadgetUrl == null) {
            return false;
        }
        if (!this.isFeatureAdminEnabled(container)) {
            return true;
        }
        GadgetContext context = gadget.getContext();
        try {
            FeatureRegistry featureRegistry = this.featureRegistryProvider.get(context.getRepository());
            if (!this.hasGadgetAdminData(container, gadgetUrl)) {
                return false;
            }
            FeatureAdminData featureAdminData = this.getGadgetAdminData(container, gadgetUrl).getFeatureAdminData();
            Set features = featureAdminData.getFeatures();
            if (featureAdminData.getType() == FeatureAdminData.Type.WHITELIST) {
                features = Sets.newHashSet(featureRegistry.getFeatures(features));
            }
            List<String> gadgetFeatures = featureRegistry.getFeatures(this.getRequiredGadgetFeatures(gadget));
            return this.areAllFeaturesAllowed(Sets.immutableSet((Collection)features), gadgetFeatures, featureAdminData);
        }
        catch (GadgetException e) {
            LOG.log(Level.WARNING, "Exception while getting the FeatureRegistry.");
            return false;
        }
    }

    private List<String> getRequiredGadgetFeatures(Gadget gadget) {
        ArrayList featureNames = Lists.newArrayList();
        List<Feature> features = gadget.getSpec().getModulePrefs().getAllFeatures();
        for (Feature feature : features) {
            if (!feature.getRequired()) continue;
            featureNames.add(feature.getName());
        }
        return featureNames;
    }

    private boolean areAllFeaturesAllowed(Set<String> featuresForGadget, List<String> gadgetFeatures, FeatureAdminData featureAdminData) {
        switch (featureAdminData.getType()) {
            case BLACKLIST: {
                for (String feature : gadgetFeatures) {
                    if (!featuresForGadget.contains(feature)) continue;
                    return false;
                }
                break;
            }
            default: {
                return featuresForGadget.containsAll(gadgetFeatures);
            }
        }
        return true;
    }

    @Override
    public boolean isAllowedFeature(Feature feature, Gadget gadget) {
        String container = this.getSafeContainerFromGadget(gadget);
        String gadgetUrl = this.getSafeGadgetUrlFromGadget(gadget);
        if (container == null || gadgetUrl == null) {
            return false;
        }
        if (!this.isFeatureAdminEnabled(container)) {
            return true;
        }
        if (!this.hasGadgetAdminData(container, gadgetUrl)) {
            return false;
        }
        GadgetAdminData gadgetAdminData = this.getGadgetAdminData(container, gadgetUrl);
        FeatureAdminData featureAdminData = gadgetAdminData.getFeatureAdminData();
        String featureName = feature.getName();
        switch (featureAdminData.getType()) {
            case BLACKLIST: {
                return !featureAdminData.getFeatures().contains(featureName);
            }
        }
        return featureAdminData.getFeatures().contains(featureName);
    }

    private boolean hasGadgetAdminData(String container, String gadgetUrl) {
        return this.getGadgetAdminData(container, gadgetUrl) != null;
    }

    @Override
    public boolean isWhitelisted(String container, String gadgetUrl) {
        if (this.isWhitelistingEnabled(container)) {
            return this.hasGadgetAdminData(container, gadgetUrl);
        }
        return true;
    }

    private boolean isWhitelistingEnabled(String container) {
        return this.config.getBool(container, WHITELIST_KEY);
    }

    private boolean isFeatureAdminEnabled(String container) {
        return this.config.getBool(container, ENABLE_FEATURE_ADMIN);
    }

    @Override
    public Set<String> getAdditionalRpcServiceIds(Gadget gadget) {
        GadgetAdminData gadgetData = this.getGadgetAdminData(this.getSafeContainerFromGadget(gadget), this.getSafeGadgetUrlFromGadget(gadget));
        Set ids = Sets.newHashSet();
        if (gadgetData != null) {
            ids.addAll(gadgetData.getRpcAdminData().getAdditionalRpcServiceIds());
        }
        return ids;
    }
}

