/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.admin;

import com.google.caja.util.Maps;
import com.google.common.base.Objects;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.gadgets.admin.GadgetAdminData;

public class ContainerAdminData {
    private static final String STAR = "*";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private Map<String, GadgetAdminData> gadgetAdminMap;

    public ContainerAdminData() {
        this(null);
    }

    public ContainerAdminData(Map<String, GadgetAdminData> gadgetAdminMap) {
        if (gadgetAdminMap == null) {
            gadgetAdminMap = Maps.newHashMap();
        }
        this.gadgetAdminMap = gadgetAdminMap;
    }

    public void addGadgetAdminData(String gadgetUrl, GadgetAdminData toAdd) {
        if (gadgetUrl != null) {
            if (toAdd == null) {
                toAdd = new GadgetAdminData();
            }
            this.gadgetAdminMap.put(gadgetUrl, toAdd);
        }
    }

    public GadgetAdminData removeGadgetAdminData(String gadgetUrl) {
        return this.gadgetAdminMap.remove(gadgetUrl);
    }

    public GadgetAdminData getGadgetAdminData(String gadgetUrl) {
        GadgetAdminData match = this.gadgetAdminMap.get(gadgetUrl);
        if (match != null) {
            return match;
        }
        String key = gadgetUrl != null ? this.getGadgetAdminDataKey(gadgetUrl) : null;
        return this.gadgetAdminMap.get(key);
    }

    public Map<String, GadgetAdminData> getGadgetAdminMap() {
        return this.gadgetAdminMap;
    }

    public void clearGadgetAdminData() {
        this.gadgetAdminMap.clear();
    }

    public boolean hasGadgetAdminData(String gadgetUrl) {
        if (this.gadgetAdminMap.keySet().contains(gadgetUrl)) {
            return true;
        }
        return gadgetUrl != null ? this.getGadgetAdminDataKey(gadgetUrl) != null : false;
    }

    private String getGadgetAdminDataKey(String gadgetUrl) {
        Set<String> gadgetUrls = this.gadgetAdminMap.keySet();
        String normalizedGadgetUrl = this.createUrlWithPort(gadgetUrl);
        String key = null;
        for (String url : gadgetUrls) {
            String normalizedUrl = this.createUrlWithPort(url);
            if (normalizedUrl.endsWith(STAR) && normalizedGadgetUrl.startsWith(normalizedUrl.substring(0, normalizedUrl.length() - 1))) {
                if (key != null && (key == null || key.length() >= normalizedUrl.length())) continue;
                key = url;
                continue;
            }
            if (!normalizedUrl.equals(normalizedGadgetUrl)) continue;
            key = url;
            break;
        }
        return key;
    }

    private String createUrlWithPort(String gadgetUrl) {
        try {
            URL origUrl = new URL(gadgetUrl);
            URL urlWithPort = null;
            String origHost = origUrl.getHost();
            if (origUrl.getPort() <= 0 && origHost != null && origHost.length() != 0 && !STAR.equals(origHost)) {
                if (origUrl.getProtocol().equalsIgnoreCase(HTTP)) {
                    urlWithPort = new URL(origUrl.getProtocol(), origUrl.getHost(), 80, origUrl.getFile());
                } else if (origUrl.getProtocol().equalsIgnoreCase(HTTPS)) {
                    urlWithPort = new URL(origUrl.getProtocol(), origUrl.getHost(), 443, origUrl.getFile());
                }
                return urlWithPort == null ? origUrl.toString() : urlWithPort.toString();
            }
            return origUrl.toString();
        }
        catch (MalformedURLException e) {
            return gadgetUrl;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContainerAdminData) {
            ContainerAdminData test = (ContainerAdminData)obj;
            Map<String, GadgetAdminData> testGadgetAdminMap = test.getGadgetAdminMap();
            return testGadgetAdminMap.equals(this.getGadgetAdminMap());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.gadgetAdminMap});
    }
}

