/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class AddJslInfoVariableProcessor
implements JsProcessor {
    private static final Logger LOG = Logger.getLogger(AddJslInfoVariableProcessor.class.getName());
    private static final String CODE_ID = "[jsload-code-info]";
    @VisibleForTesting
    static final String BASE_HINT_TEMPLATE = "window['___jsl'] = window['___jsl'] || {};";
    @VisibleForTesting
    static final String FEATURES_HINT_TEMPLATE = "window['___jsl']['f'] = [%s];";
    private final FeatureRegistryProvider featureRegistryProvider;

    @Inject
    public AddJslInfoVariableProcessor(FeatureRegistryProvider featureRegistryProvider) {
        this.featureRegistryProvider = featureRegistryProvider;
    }

    @Override
    public boolean process(JsRequest jsRequest, JsResponseBuilder builder) {
        JsUriManager.JsUri jsUri = jsRequest.getJsUri();
        if (!jsUri.isNohint()) {
            String features = this.getFeatures(jsUri);
            builder.prependJs(String.format(FEATURES_HINT_TEMPLATE, features), CODE_ID, true);
            builder.prependJs(BASE_HINT_TEMPLATE, CODE_ID);
        }
        return true;
    }

    private String getFeatures(JsUriManager.JsUri jsUri) {
        FeatureRegistry registry;
        block4: {
            registry = null;
            String repository = jsUri.getRepository();
            try {
                registry = this.featureRegistryProvider.get(repository);
            }
            catch (GadgetException e) {
                if (!LOG.isLoggable(Level.WARNING)) break block4;
                LOG.log(Level.WARNING, "No registry found for repository: " + repository, e);
            }
        }
        if (registry != null) {
            List<String> features = registry.getFeatures(jsUri.getLibs());
            TreeSet encoded = Sets.newTreeSet();
            for (String feature : features) {
                encoded.add('\'' + StringEscapeUtils.escapeEcmaScript((String)feature) + '\'');
            }
            return StringUtils.join((Iterable)encoded, (String)",");
        }
        return "";
    }
}

