/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class JsRequestBuilder {
    private final JsUriManager jsUriManager;
    private final FeatureRegistry registry;

    @Inject
    public JsRequestBuilder(JsUriManager jsUriManager, FeatureRegistry registry) {
        this.jsUriManager = jsUriManager;
        this.registry = registry;
    }

    public JsRequest build(HttpServletRequest request) throws GadgetException {
        JsUriManager.JsUri jsUri = this.jsUriManager.processExternJsUri(new UriBuilder(request).toUri());
        String host = request.getHeader("Host");
        boolean inCache = request.getHeader("If-Modified-Since") != null;
        return this.build(jsUri, host, inCache);
    }

    public JsRequest build(JsUriManager.JsUri jsUri, String host) {
        return this.build(jsUri, host, false);
    }

    protected JsRequest build(JsUriManager.JsUri jsUri, String host, boolean inCache) {
        return new JsRequest(jsUri, host, inCache, this.registry);
    }
}

