/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.auth.OAuthUtil;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.gadgets.http.BasicHttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth.AccessorInfo;
import org.apache.shindig.gadgets.oauth.OAuthRequest;

public class OAuthCommandLine {
    public static void main(String[] argv) throws Exception {
        HashMap params = Maps.newHashMap();
        for (int i = 0; i < argv.length; i += 2) {
            params.put(argv[i], argv[i + 1]);
        }
        String httpProxy = (String)params.get("--httpProxy");
        String consumerKey = (String)params.get("--consumerKey");
        String consumerSecret = (String)params.get("--consumerSecret");
        String xOauthRequestor = (String)params.get("--requestorId");
        String accessToken = (String)params.get("--accessToken");
        String tokenSecret = (String)params.get("--tokenSecret");
        String method = params.get("--method") == null ? "GET" : (String)params.get("--method");
        String url = (String)params.get("--url");
        String contentType = (String)params.get("--contentType");
        String postBody = (String)params.get("--postBody");
        String postFile = (String)params.get("--postFile");
        String paramLocation = (String)params.get("--paramLocation");
        String bodySigning = (String)params.get("--bodySigning");
        HttpRequest request = new HttpRequest(Uri.parse((String)url));
        if (contentType != null) {
            request.setHeader("Content-Type", contentType);
        } else {
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        if (postBody != null) {
            request.setPostBody(postBody.getBytes());
        }
        if (postFile != null) {
            request.setPostBody(IOUtils.toByteArray((InputStream)new FileInputStream(postFile)));
        }
        AccessorInfo.OAuthParamLocation paramLocationEnum = AccessorInfo.OAuthParamLocation.URI_QUERY;
        if (paramLocation != null) {
            paramLocationEnum = AccessorInfo.OAuthParamLocation.valueOf(paramLocation);
        }
        BodySigning bodySigningEnum = BodySigning.none;
        if (bodySigning != null) {
            bodySigningEnum = BodySigning.valueOf(bodySigning);
        }
        ArrayList oauthParams = Lists.newArrayList();
        UriBuilder target = new UriBuilder(Uri.parse((String)url));
        String query = target.getQuery();
        target.setQuery(null);
        oauthParams.addAll(OAuth.decodeForm((String)query));
        if (OAuth.isFormEncoded((String)contentType) && request.getPostBodyAsString() != null) {
            oauthParams.addAll(OAuth.decodeForm((String)request.getPostBodyAsString()));
        } else if (bodySigningEnum == BodySigning.legacy) {
            oauthParams.add(new OAuth.Parameter(request.getPostBodyAsString(), ""));
        } else if (bodySigningEnum == BodySigning.hash) {
            oauthParams.add(new OAuth.Parameter("oauth_body_hash", new String(Base64.encodeBase64((byte[])DigestUtils.sha((byte[])request.getPostBodyAsString().getBytes())), "UTF-8")));
        }
        if (consumerKey != null) {
            oauthParams.add(new OAuth.Parameter("oauth_consumer_key", consumerKey));
        }
        if (xOauthRequestor != null) {
            oauthParams.add(new OAuth.Parameter("xoauth_requestor_id", xOauthRequestor));
        }
        OAuthConsumer consumer = new OAuthConsumer(null, consumerKey, consumerSecret, null);
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        accessor.accessToken = accessToken;
        accessor.tokenSecret = tokenSecret;
        OAuthMessage message = accessor.newRequestMessage(method, target.toString(), (Collection)oauthParams);
        List<Map.Entry<String, String>> entryList = OAuthRequest.selectOAuthParams(message);
        switch (paramLocationEnum) {
            case AUTH_HEADER: {
                request.addHeader("Authorization", OAuthRequest.getAuthorizationHeader(entryList));
                break;
            }
            case POST_BODY: {
                if (!OAuth.isFormEncoded((String)contentType)) {
                    throw new RuntimeException("OAuth param location can only be post_body if post body if of type x-www-form-urlencoded");
                }
                String oauthData = OAuthUtil.formEncode((Iterable)message.getParameters());
                request.setPostBody(CharsetUtil.getUtf8Bytes((String)oauthData));
                break;
            }
            case URI_QUERY: {
                request.setUri(Uri.parse((String)OAuthUtil.addParameters((String)request.getUri().toString(), entryList)));
            }
        }
        request.setMethod(method);
        BasicHttpFetcher fetcher = new BasicHttpFetcher(httpProxy);
        HttpResponse response = fetcher.fetch(request);
        System.out.println("Request ------------------------------");
        System.out.println(request.toString());
        System.out.println("Response -----------------------------");
        System.out.println(response.toString());
    }

    public static enum BodySigning {
        none,
        hash,
        legacy;

    }
}

