/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;

public class OAuth2GadgetContext
extends GadgetContext {
    private final Uri appUrl;
    private final boolean bypassSpecCache;
    private final String container;
    private final String scope;
    private final SecurityToken securityToken;

    public OAuth2GadgetContext(SecurityToken securityToken, OAuth2Arguments arguments, Uri gadgetUri) {
        this.securityToken = securityToken;
        this.container = securityToken.getContainer();
        this.appUrl = gadgetUri;
        this.bypassSpecCache = arguments.getBypassSpecCache();
        this.scope = arguments.getScope();
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public boolean getIgnoreCache() {
        return this.bypassSpecCache;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public SecurityToken getToken() {
        return this.securityToken;
    }

    @Override
    public Uri getUrl() {
        return this.appUrl;
    }
}

