/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.CacheEnforcementVisitor;
import org.apache.shindig.gadgets.rewrite.ConcatVisitor;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.ResourceMutateVisitor;
import org.apache.shindig.gadgets.uri.ConcatUriManager;

public class StyleConcatContentRewriter
extends DomWalker.Rewriter {
    private final ContentRewriterFeature.Factory featureConfigFactory;
    private final ConcatUriManager concatUriManager;
    private final Executor executor;
    private final RequestPipeline requestPipeline;
    private final HttpCache cache;

    @Inject
    public StyleConcatContentRewriter(ConcatUriManager concatUriManager, ContentRewriterFeature.Factory featureConfigFactory, @Named(value="shindig.concat.executor") Executor executor, HttpCache cache, RequestPipeline requestPipeline) {
        this.concatUriManager = concatUriManager;
        this.featureConfigFactory = featureConfigFactory;
        this.executor = executor;
        this.cache = cache;
        this.requestPipeline = requestPipeline;
    }

    @Override
    protected List<DomWalker.Visitor> makeVisitors(Gadget context, Uri gadgetUri) {
        ContentRewriterFeature.Config config = this.featureConfigFactory.get(context.getSpec());
        return Arrays.asList(new CacheEnforcementVisitor(config, this.executor, this.cache, this.requestPipeline, ResourceMutateVisitor.Tags.STYLESHEET), new ConcatVisitor.Css(config, this.concatUriManager));
    }
}

