/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.ContentType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.gadgets.servlet.ModuleCacheKey;

final class ModuleCache
extends JobCache {
    private final Cache<ModuleCacheKey, ImmutableList<Job>> backingCache;

    ModuleCache(Cache<ModuleCacheKey, ImmutableList<Job>> backingCache) {
        this.backingCache = backingCache;
    }

    public ModuleCacheKey forJob(ContentType type, ParseTreeNode node) {
        return new ModuleCacheKey(type, node);
    }

    public List<? extends Job> fetch(JobCache.Key k) {
        if (!(k instanceof ModuleCacheKey)) {
            return null;
        }
        ImmutableList cachedJobs = (ImmutableList)this.backingCache.getElement((Object)((ModuleCacheKey)k));
        if (cachedJobs == null) {
            return null;
        }
        if (cachedJobs.isEmpty()) {
            return cachedJobs;
        }
        return ModuleCache.cloneJobs((Iterable<? extends Job>)cachedJobs);
    }

    public void store(JobCache.Key k, List<? extends Job> derivatives) {
        if (!(k instanceof ModuleCacheKey)) {
            throw new IllegalArgumentException(k.getClass().getName());
        }
        ModuleCacheKey key = (ModuleCacheKey)k;
        this.backingCache.addElement((Object)key, ModuleCache.cloneJobs(derivatives));
    }

    private static ImmutableList<Job> cloneJobs(Iterable<? extends Job> jobs) {
        ImmutableList.Builder clones = ImmutableList.builder();
        for (Job job : jobs) {
            clones.add((Object)job.clone());
        }
        return clones.build();
    }
}

