/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.auth.AuthInfoUtil;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;
import org.apache.shindig.gadgets.servlet.ProxyHandler;
import org.apache.shindig.gadgets.servlet.ServletUtil;
import org.apache.shindig.gadgets.uri.ProxyUriManager;

public class ProxyServlet
extends InjectedServlet {
    private static final long serialVersionUID = 9085050443492307723L;
    private static final String classname = ProxyServlet.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private transient ProxyUriManager proxyUriManager;
    private transient LockedDomainService lockedDomainService;
    private transient ProxyHandler proxyHandler;

    @Inject
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.checkInitialized();
        this.proxyHandler = proxyHandler;
    }

    @Inject
    public void setProxyUriManager(ProxyUriManager proxyUriManager) {
        this.checkInitialized();
        this.proxyUriManager = proxyUriManager;
    }

    @Inject
    public void setLockedDomainService(LockedDomainService lockedDomainService) {
        this.checkInitialized();
        this.lockedDomainService = lockedDomainService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse servletResponse) throws IOException {
        this.processRequest(request, servletResponse);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse servletResponse) throws IOException {
        this.processRequest(request, servletResponse);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse servletResponse) throws IOException {
        HttpResponse response;
        if (request.getHeader("If-Modified-Since") != null) {
            servletResponse.setStatus(304);
            return;
        }
        Uri reqUri = new UriBuilder(request).toUri();
        try {
            AuthType authType;
            ProxyUriManager.ProxyUri proxyUri = this.proxyUriManager.process(reqUri);
            SecurityToken st = AuthInfoUtil.getSecurityTokenFromRequest((HttpServletRequest)request);
            proxyUri.setSecurityToken(st);
            proxyUri.setUserAgent(request.getHeader("User-Agent"));
            if (proxyUri.getGadget() == null && st != null && !st.isAnonymous()) {
                proxyUri.setGadget(st.getAppUrl());
            }
            if (AuthType.OAUTH.equals((Object)(authType = proxyUri.getAuthType()))) {
                proxyUri.setOAuthArguments(new OAuthArguments(AuthType.OAUTH, request));
            } else if (AuthType.OAUTH2.equals((Object)authType)) {
                proxyUri.setOAuth2Arguments(new OAuth2Arguments(request));
            }
            String host = request.getHeader("Host");
            if (!this.lockedDomainService.isSafeForOpenProxy(host)) {
                Uri resourceUri = proxyUri.getResource();
                String msg = "Embed request for url " + (resourceUri != null ? resourceUri.toString() : "n/a") + " made to wrong domain " + host;
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "processRequest", "embededImgWrongDomain", new Object[]{resourceUri != null ? resourceUri.toString() : "n/a", host});
                }
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, msg, 400);
            }
            if ("POST".equalsIgnoreCase(request.getMethod())) {
                StringBuffer buffer = this.getPOSTContent(request);
                response = this.proxyHandler.fetch(proxyUri, buffer.toString());
            } else {
                response = this.proxyHandler.fetch(proxyUri);
            }
        }
        catch (GadgetException e) {
            response = ServletUtil.errorResponse(new GadgetException(e.getCode(), e.getMessage(), 400));
        }
        ServletUtil.copyToServletResponseAndOverrideCacheHeaders(response, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getPOSTContent(HttpServletRequest request) throws IOException {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            int letter = 0;
            while ((letter = reader.read()) != -1) {
                buffer.append((char)letter);
            }
            reader.close();
        }
        catch (IOException e) {
            try {
                LOG.logp(Level.WARNING, classname, "getPOSTContent", "Caught exception while reading POST body:" + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
        return buffer;
    }
}

