/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.servlet.JsonRpcHandler;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.json.JSONException;
import org.json.JSONObject;

public class RpcServlet
extends InjectedServlet {
    private static final long serialVersionUID = 1382573217773582182L;
    static final String GET_REQUEST_REQ_PARAM = "req";
    static final String GET_REQUEST_CALLBACK_PARAM = "callback";
    private static final Logger LOG = Logger.getLogger("org.apache.shindig.gadgets.servlet.RpcServlet");
    private transient JsonRpcHandler jsonHandler;
    private Boolean isJSONPAllowed;

    @Inject
    public void setJsonRpcHandler(JsonRpcHandler jsonHandler) {
        this.checkInitialized();
        this.jsonHandler = jsonHandler;
    }

    @Inject
    public void setJSONPAllowed(@Named(value="shindig.allowJSONP") Boolean isJSONPAllowed) {
        this.isJSONPAllowed = isJSONPAllowed;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String reqValue;
        String callbackValue;
        try {
            if (this.isJSONPAllowed.booleanValue()) {
                HttpUtil.isJSONP((HttpServletRequest)request);
                callbackValue = this.validateParameterValue(request, GET_REQUEST_CALLBACK_PARAM);
            } else {
                callbackValue = this.validateParameterValueNull(request, GET_REQUEST_CALLBACK_PARAM);
            }
            reqValue = this.validateParameterValue(request, GET_REQUEST_REQ_PARAM);
        }
        catch (IllegalArgumentException e) {
            response.setStatus(400);
            LOG.log(Level.INFO, e.getMessage(), e);
            return;
        }
        Result result = this.process(request, response, reqValue);
        if (result.isSuccess()) {
            if (callbackValue != null) {
                response.getWriter().write(callbackValue + '(' + result.getOutput() + ')');
            } else {
                response.getWriter().write(result.getOutput());
            }
        } else {
            response.getWriter().write(result.getOutput());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            InputStreamReader is = new InputStreamReader((InputStream)request.getInputStream(), this.getRequestCharacterEncoding(request));
            String body = IOUtils.toString((Reader)is);
            Result result = this.process(request, response, body);
            response.getWriter().write(result.getOutput());
        }
        catch (UnsupportedEncodingException e) {
            response.setStatus(400);
            LOG.log(Level.INFO, e.getMessage(), e);
            response.getWriter().write("Unsupported input character set");
        }
    }

    private String validateParameterValue(HttpServletRequest request, String parameter) throws IllegalArgumentException {
        String result = request.getParameter(parameter);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No parameter '%s' specified", (Object[])new Object[]{parameter});
        return result;
    }

    private String validateParameterValueNull(HttpServletRequest request, String parameter) throws IllegalArgumentException {
        String result = request.getParameter(parameter);
        Preconditions.checkArgument((result == null ? 1 : 0) != 0, (String)"Wrong parameter '%s' found", (Object[])new Object[]{parameter});
        return result;
    }

    private Result process(HttpServletRequest request, HttpServletResponse response, String body) {
        try {
            JSONObject req = new JSONObject(body);
            JSONObject resp = this.jsonHandler.process(req);
            response.setStatus(200);
            response.setContentType("application/json; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=rpc.txt");
            return new Result(resp.toString(), true);
        }
        catch (JSONException e) {
            response.setStatus(400);
            return new Result("Malformed JSON request.", false);
        }
        catch (RpcException e) {
            response.setStatus(500);
            LOG.log(Level.INFO, e.getMessage(), e);
            return new Result(e.getMessage(), false);
        }
    }

    private String getRequestCharacterEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private static class Result {
        private final String output;
        private final boolean success;

        public Result(String output, boolean success) {
            this.output = output;
            this.success = success;
        }

        public String getOutput() {
            return this.output;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

