/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

public class ProxyUriBase {
    @Inject(optional=true)
    @Named(value="org.apache.shindig.gadgets.uri.setAuthorityAsGadgetParam")
    private static boolean setAuthorityAsGadgetParam = false;
    private UriStatus status = null;
    private Integer refresh = null;
    private boolean debug = false;
    private boolean noCache = false;
    private String container = "default";
    private String gadget = null;
    private String rewriteMimeType = null;
    private boolean sanitizeContent = false;
    private boolean cajoleContent = false;
    protected Map<String, String> extensionParams = null;

    protected ProxyUriBase(Gadget gadget) {
        this(null, ProxyUriBase.getIntegerValue(gadget.getContext().getParameter(UriCommon.Param.REFRESH.getKey())), gadget.getContext().getDebug(), gadget.getContext().getIgnoreCache(), gadget.getContext().getContainer(), setAuthorityAsGadgetParam ? gadget.getSpec().getUrl().getAuthority() : gadget.getSpec().getUrl().toString());
    }

    protected ProxyUriBase(UriStatus status, Uri origUri) {
        this.status = status;
        this.setFromUri(origUri);
    }

    protected ProxyUriBase(UriStatus status, Integer refresh, boolean debug, boolean noCache, String container, String gadget) {
        this.status = status;
        this.refresh = refresh;
        this.debug = debug;
        this.noCache = noCache;
        this.container = container;
        this.gadget = gadget;
    }

    public void setFromUri(Uri uri) {
        if (uri != null) {
            this.refresh = ProxyUriBase.getIntegerValue(uri.getQueryParameter(UriCommon.Param.REFRESH.getKey()));
            this.debug = ProxyUriBase.getTruthyValue(uri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
            this.noCache = ProxyUriBase.getBooleanValue(uri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
            String newContainer = uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey());
            if (newContainer == null) {
                newContainer = uri.getQueryParameter(UriCommon.Param.SYND.getKey());
            }
            if (newContainer != null) {
                this.container = newContainer;
            }
            this.gadget = uri.getQueryParameter(UriCommon.Param.GADGET.getKey());
            this.rewriteMimeType = uri.getQueryParameter(UriCommon.Param.REWRITE_MIME_TYPE.getKey());
            this.sanitizeContent = ProxyUriBase.getBooleanValue(uri.getQueryParameter(UriCommon.Param.SANITIZE.getKey()));
            this.cajoleContent = ProxyUriBase.getBooleanValue(uri.getQueryParameter(UriCommon.Param.CAJOLE.getKey()));
        }
    }

    protected static boolean getTruthyValue(String str) {
        return str != null && !"0".equals(str) && str.length() > 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProxyUriBase)) {
            return false;
        }
        ProxyUriBase objUri = (ProxyUriBase)obj;
        return Objects.equal((Object)((Object)this.status), (Object)((Object)objUri.status)) && (this.noCache || Objects.equal((Object)this.refresh, (Object)objUri.refresh)) && Objects.equal((Object)this.container, (Object)objUri.container) && Objects.equal((Object)this.gadget, (Object)objUri.gadget) && Objects.equal((Object)this.rewriteMimeType, (Object)objUri.rewriteMimeType) && this.noCache == objUri.noCache && this.debug == objUri.debug && this.sanitizeContent == objUri.sanitizeContent && this.cajoleContent == objUri.cajoleContent && Objects.equal(this.extensionParams, objUri.extensionParams);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.status, this.refresh, this.container, this.gadget, this.rewriteMimeType, this.noCache, this.debug, this.sanitizeContent, this.cajoleContent});
    }

    public ProxyUriBase setRewriteMimeType(String type) {
        this.rewriteMimeType = type;
        return this;
    }

    public ProxyUriBase setSanitizeContent(boolean sanitize) {
        this.sanitizeContent = sanitize;
        return this;
    }

    public ProxyUriBase setCajoleContent(boolean cajole) {
        this.cajoleContent = cajole;
        return this;
    }

    public ProxyUriBase setGadget(String gadget) {
        this.gadget = gadget;
        return this;
    }

    public UriStatus getStatus() {
        return this.status;
    }

    public Integer getRefresh() {
        return this.noCache ? Integer.valueOf(0) : this.refresh;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public String getContainer() {
        return this.container;
    }

    public String getGadget() {
        return this.gadget;
    }

    public String getRewriteMimeType() {
        return this.rewriteMimeType;
    }

    public boolean sanitizeContent() {
        return this.sanitizeContent;
    }

    public boolean cajoleContent() {
        return this.cajoleContent;
    }

    public void setExtensionParam(String key, String val) {
        if (this.extensionParams == null) {
            this.extensionParams = Maps.newHashMap();
        }
        this.extensionParams.put(key, val);
    }

    public String getExtensionParam(String key) {
        if (this.extensionParams == null) {
            return null;
        }
        return this.extensionParams.get(key);
    }

    public ProxyUriBase setExtensionParams(Map<String, String> extensionParams) {
        this.extensionParams = extensionParams;
        return this;
    }

    public Map<String, String> getExtensionParams() {
        return this.extensionParams;
    }

    public HttpRequest makeHttpRequest(Uri targetUri) throws GadgetException {
        HttpRequest req = new HttpRequest(targetUri).setIgnoreCache(this.isNoCache()).setContainer(this.getContainer());
        if (!Strings.isNullOrEmpty((String)this.getGadget())) {
            try {
                req.setGadget(Uri.parse((String)this.getGadget()));
            }
            catch (IllegalArgumentException e) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid " + UriCommon.Param.GADGET.getKey() + " param: " + this.getGadget(), 400);
            }
        }
        if (this.getRefresh() != null && this.getRefresh() >= 0) {
            req.setCacheTtl(this.getRefresh());
        }
        if (this.rewriteMimeType != null) {
            req.setRewriteMimeType(this.getRewriteMimeType());
        }
        req.setSanitizationRequested(this.sanitizeContent());
        req.setCajaRequested(this.cajoleContent());
        return req;
    }

    public UriBuilder makeQueryParams(Integer forcedRefresh, String version) {
        UriBuilder queryBuilder = new UriBuilder();
        String container = this.getContainer();
        queryBuilder.addQueryParameter(UriCommon.Param.CONTAINER.getKey(), container);
        if (this.getGadget() != null) {
            queryBuilder.addQueryParameter(UriCommon.Param.GADGET.getKey(), this.getGadget());
        }
        queryBuilder.addQueryParameter(UriCommon.Param.DEBUG.getKey(), this.isDebug() ? "1" : "0");
        queryBuilder.addQueryParameter(UriCommon.Param.NO_CACHE.getKey(), this.isNoCache() ? "1" : "0");
        if (!this.isNoCache()) {
            if (forcedRefresh != null && forcedRefresh >= 0) {
                queryBuilder.addQueryParameter(UriCommon.Param.REFRESH.getKey(), forcedRefresh.toString());
            } else if (this.getRefresh() != null) {
                queryBuilder.addQueryParameter(UriCommon.Param.REFRESH.getKey(), this.getRefresh().toString());
            }
        }
        if (version != null) {
            queryBuilder.addQueryParameter(UriCommon.Param.VERSION.getKey(), version);
        }
        if (this.rewriteMimeType != null) {
            queryBuilder.addQueryParameter(UriCommon.Param.REWRITE_MIME_TYPE.getKey(), this.rewriteMimeType);
        }
        if (this.sanitizeContent) {
            queryBuilder.addQueryParameter(UriCommon.Param.SANITIZE.getKey(), "1");
        }
        if (this.cajoleContent) {
            queryBuilder.addQueryParameter(UriCommon.Param.CAJOLE.getKey(), "1");
        }
        if (this.extensionParams != null) {
            queryBuilder.addQueryParameters(this.extensionParams);
        }
        return queryBuilder;
    }

    public Integer translateStatusRefresh(int longVal, int originalResourceTtl) throws GadgetException {
        Integer retRefresh = 0;
        switch (this.getStatus()) {
            case VALID_VERSIONED: {
                retRefresh = longVal;
                break;
            }
            case VALID_UNVERSIONED: {
                retRefresh = originalResourceTtl;
                break;
            }
            case INVALID_VERSION: {
                retRefresh = 0;
                break;
            }
            case BAD_URI: {
                throw new GadgetException(GadgetException.Code.INVALID_PATH, "Invalid path", 400);
            }
            default: {
                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Unknown status: " + (Object)((Object)this.getStatus()));
            }
        }
        Integer setVal = this.getRefresh();
        if (setVal != null && setVal != -1) {
            retRefresh = setVal;
        }
        return retRefresh;
    }

    protected static boolean getBooleanValue(String str) {
        return str != null && "1".equals(str);
    }

    protected static Integer getIntegerValue(String str) {
        try {
            return NumberUtils.createInteger((String)str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

