/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.variables.Substituter;
import org.apache.shindig.gadgets.variables.Substitutions;

public class VariableSubstituter {
    private final List<Substituter> substituters;

    @Inject
    public VariableSubstituter(@Named(value="shindig.substituters.gadget") List<Substituter> substituters) {
        this.substituters = ImmutableList.copyOf(substituters);
    }

    public GadgetSpec substitute(GadgetContext context, GadgetSpec spec) throws GadgetException {
        Substitutions substitutions = new Substitutions();
        for (Substituter substituter : this.substituters) {
            substituter.addSubstitutions(substitutions, context, spec);
        }
        return spec.substitute(substitutions);
    }
}

