/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.mitre.openid.connect.client.OIDCAuthoritiesMapper;
import org.mitre.openid.connect.client.SubjectIssuerGrantedAuthority;
import org.mitre.openid.connect.model.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class NamedAdminAuthoritiesMapper
implements OIDCAuthoritiesMapper {
    private static Logger logger = LoggerFactory.getLogger(NamedAdminAuthoritiesMapper.class);
    private static final SimpleGrantedAuthority ROLE_ADMIN = new SimpleGrantedAuthority("ROLE_ADMIN");
    private static final SimpleGrantedAuthority ROLE_USER = new SimpleGrantedAuthority("ROLE_USER");
    private Set<SubjectIssuerGrantedAuthority> admins = new HashSet<SubjectIssuerGrantedAuthority>();

    @Override
    public Collection<? extends GrantedAuthority> mapAuthorities(JWT idToken, UserInfo userInfo) {
        HashSet<SubjectIssuerGrantedAuthority> out = new HashSet<SubjectIssuerGrantedAuthority>();
        try {
            JWTClaimsSet claims = idToken.getJWTClaimsSet();
            SubjectIssuerGrantedAuthority authority = new SubjectIssuerGrantedAuthority(claims.getSubject(), claims.getIssuer());
            out.add(authority);
            if (this.admins.contains(authority)) {
                out.add((SubjectIssuerGrantedAuthority)ROLE_ADMIN);
            }
            out.add((SubjectIssuerGrantedAuthority)ROLE_USER);
        }
        catch (ParseException e) {
            logger.error("Unable to parse ID Token inside of authorities mapper (huh?)");
        }
        return out;
    }

    public Set<SubjectIssuerGrantedAuthority> getAdmins() {
        return this.admins;
    }

    public void setAdmins(Set<SubjectIssuerGrantedAuthority> admins) {
        this.admins = admins;
    }
}

