/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client;

import com.google.common.base.Strings;
import org.springframework.security.core.GrantedAuthority;

public class SubjectIssuerGrantedAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 5584978219226664794L;
    private final String subject;
    private final String issuer;

    public SubjectIssuerGrantedAuthority(String subject, String issuer) {
        if (Strings.isNullOrEmpty((String)subject) || Strings.isNullOrEmpty((String)issuer)) {
            throw new IllegalArgumentException("Neither subject nor issuer may be null or empty");
        }
        this.subject = subject;
        this.issuer = issuer;
    }

    public String getAuthority() {
        return "OIDC_" + this.subject + "_" + this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.issuer == null ? 0 : this.issuer.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectIssuerGrantedAuthority)) {
            return false;
        }
        SubjectIssuerGrantedAuthority other = (SubjectIssuerGrantedAuthority)obj;
        if (this.issuer == null ? other.issuer != null : !this.issuer.equals(other.issuer)) {
            return false;
        }
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }

    public String toString() {
        return this.getAuthority();
    }
}

